<?php
include("config.php");
include 'common/header.php';

$city = "";
$where = "";

// ✅ Check if city filter is applied
if (isset($_GET['city']) && $_GET['city'] != "") {
    $city = trim($_GET['city']);
    $where = "WHERE u.city LIKE '%" . $conn->real_escape_string($city) . "%'";
} else {
    $where = ""; // no filter
}

// ✅ Fetch attempts with user names + file + optional city filter
$sql = "
    SELECT a.exam_id, a.user_id, u.name, a.score, a.total, u.city, a.summary_pdf
    FROM attempts a
    JOIN users u ON a.user_id = u.id
    $where
    ORDER BY a.exam_id, a.user_id
";


$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Exam Results</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f5f6fa;
        }

        .container {
            width: 80%;
            margin: 40px auto;
        }

        h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        th,
        td {
            padding: 12px 15px;
            text-align: center;
            border-bottom: 1px solid #eee;
        }

        th {
            background: #3498db;
            color: #fff;
        }

        tr:hover {
            background: #f1f1f1;
        }

        .score {
            font-weight: bold;
            color: #27ae60;
        }

        a.download-btn {
            display: inline-block;
            padding: 6px 12px;
            background: #2ecc71;
            color: #fff;
            border-radius: 6px;
            text-decoration: none;
        }

        a.download-btn:hover {
            background: #27ae60;
        }

        /* 🔍 Filter Form Styling */
        .filter-form {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 12px;
            margin-bottom: 25px;
            background: #fff;
            padding: 15px 20px;
            border-radius: 12px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .filter-form input[type="text"] {
            padding: 10px 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            outline: none;
            font-size: 14px;
            width: 250px;
            transition: 0.3s;
        }

        .filter-form input[type="text"]:focus {
            border-color: #3498db;
            box-shadow: 0 0 6px rgba(52, 152, 219, 0.4);
        }

        .filter-form button {
            padding: 10px 18px;
            border: none;
            background: #3498db;
            color: white;
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            transition: 0.3s;
        }

        .filter-form button:hover {
            background: #2980b9;
        }

        .filter-form .clear-btn {
            padding: 9px 15px;
            background: #e74c3c;
            color: #fff;
            border-radius: 8px;
            text-decoration: none;
            font-size: 14px;
            transition: 0.3s;
        }

        .filter-form .clear-btn:hover {
            background: #c0392b;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>📊 Exam Results</h2>
        <!-- 🔍 City Filter Form -->
        <form method="get" action="" class="filter-form">
            <input type="text" name="city" placeholder="Search by city" value="<?= htmlspecialchars($city) ?>">
            <button type="submit">Search</button>
            <?php if ($city): ?>
            <a href="result.php" class="clear-btn">Clear</a>
            <?php endif; ?>
        </form>
        <table>
            <tr>
                <th>S.No.</th>
                <th>Exam ID</th>
                <th>User ID</th>
                <th>User Name</th>
                <th>Score</th>
                <th>Percentage</th>                
                <th>Centre</th>
                <th>File</th>
                <th>Actions</th>
            </tr>
            <?php if ($result && $result->num_rows > 0): ?>
            <?php $sno = 1; ?>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td>
                    <?= $sno++ ?>
                </td>
                <td>
                    <?= htmlspecialchars($row['exam_id']) ?>
                </td>
                <td>
                    <?= htmlspecialchars($row['user_id']) ?>
                </td>
                <td>
                    <?= htmlspecialchars($row['name']) ?>
                </td>
                <td class="score">
                    <?= htmlspecialchars($row['score']) . " / " . htmlspecialchars($row['total']) ?>
                </td>
                <td>
                <?php 
                if ($row['total'] > 0) {
                    $percentage = ($row['score'] / $row['total']) * 100;
                    echo number_format($percentage, 2) . '%';
                } else {
                    echo "0%";
                }
                ?>
            </td>
            <td>
                 <a href="?city=<?= urlencode($row['city']) ?>" style="color:#3498db; text-decoration:none;">
                  <?= htmlspecialchars($row['city']) ?>
                </a>
            </td>

            <td>
                <?php if (!empty($row['summary_pdf'])): ?>
                    <a href="<?= htmlspecialchars($row['summary_pdf']) ?>" class="download-btn" download>
                        Download
                    </a>
                <?php else: ?>
                    —
                <?php endif; ?>
            </td>

<td>
    <form method="post" action="delete_result.php" onsubmit="return confirm('Are you sure you want to delete this record?');" style="display:inline;">
        <input type="hidden" name="exam_id" value="<?= htmlspecialchars($row['exam_id']) ?>">
        <input type="hidden" name="user_id" value="<?= htmlspecialchars($row['user_id']) ?>">
        <button type="submit" style="background:#e74c3c; color:#fff; border:none; padding:6px 12px; border-radius:6px; cursor:pointer;">
            Delete
                </button>
                </form>
                </td>
            </tr>
            <?php endwhile; ?>
            <?php else: ?>
            <tr>
                <td colspan="6">No results found.</td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
</body>

</html>