<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'config.php';

// ✅ Handle Delete
if (isset($_GET['delete'])) {
    $delete_id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM users WHERE id = '$delete_id'");
    header("Location: " . $_SERVER['PHP_SELF'] . "?msg=deleted");
    exit();
}
include 'common/header.php';

// ✅ Fetch users from users table
// ✅ Fetch users from users table but exclude admins
$sql = "SELECT id, name, email, city, created_at 
        FROM users 
        WHERE role != 'admin'";   // or role_id != 1
$result = mysqli_query($conn, $sql);
if (!$result) {
    die("Query Failed: " . mysqli_error($conn));
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Students List</title>
    <!-- ✅ Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    
    <style>
        body {
            background-color: #f8f9fa;
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
        }

        h2 {
            font-weight: 600;
            color: #333;
        }

        .table th {
            background: #3498db;
            color: #fff;
            text-transform: uppercase;
            font-size: 13px;
            letter-spacing: 0.5px;
        }

        .table td {
            vertical-align: middle;
            font-size: 14px;
        }

        .btn-sm {
            padding: 4px 10px;
            font-size: 13px;
        }

        .alert {
            border-radius: 8px;
            font-size: 14px;
        }

        .container {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        }
    </style>
</head>
<body class="p-4">

<div class="container">
    <h2 class="mb-4 text-center">Registered Students</h2>

    <!-- ✅ Success Message -->
    <?php if (isset($_GET['msg']) && $_GET['msg'] === 'deleted'): ?>
        <div class="alert alert-success">User deleted successfully.</div>
    <?php endif; ?>

    <table class="table table-bordered table-hover table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Centre</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php if (mysqli_num_rows($result) > 0): ?>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['id']); ?></td>
                    <td><?php echo ucwords(strtolower(htmlspecialchars($row['name']))); ?></td>
                    <td><?php echo htmlspecialchars($row['email']); ?></td>
                    <td><?php echo htmlspecialchars($row['city']); ?></td>
                    <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                    <td>
                        <a href="edit.php?id=<?php echo urlencode($row['id']); ?>" 
                           class="btn btn-warning btn-sm">Edit</a>
                        <a href="?delete=<?php echo urlencode($row['id']); ?>" 
                           class="btn btn-danger btn-sm"
                           onclick="return confirm('Are you sure you want to delete this user?');">
                           Delete
                        </a>
                    </td>
                </tr>
            <?php endwhile; ?>
        <?php else: ?>
            <tr>
                <td colspan="6" class="text-center">No users registered.</td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- ✅ Bootstrap JS (for alert close animations if needed) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
