<?php
session_start();
include 'config.php';

$msg = "";
$step = 1;
$email = "";

// Step 1: Ask for email
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email'])) {
    $email = trim($_POST['email']);

    if (!empty($email)) {
        $stmt = $conn->prepare("SELECT id FROM users WHERE email=?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $res = $stmt->get_result();

        if ($res && $res->num_rows === 1) {
            $_SESSION['reset_email'] = $email;
            $step = 2; // move to password reset form
        } else {
            $msg = "❌ No account found with that email.";
        }
    }
}

// Step 2: Handle password reset
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['new_password'])) {
    if (!isset($_SESSION['reset_email'])) {
        $msg = "Session expired. Please try again.";
    } else {
        $newPass = $_POST['new_password'];
        $confirmPass = $_POST['confirm_password'];
        $email = $_SESSION['reset_email'];

        if ($newPass === $confirmPass) {
            $hash = password_hash($newPass, PASSWORD_DEFAULT);

            $stmt = $conn->prepare("UPDATE users SET password_hash=? WHERE email=?");
            $stmt->bind_param("ss", $hash, $email);
            $stmt->execute();

            unset($_SESSION['reset_email']);
            $msg = "✅ Password updated successfully! <a href='login.php'>Login</a>";
            $step = 1;
        } else {
            $msg = "❌ Passwords do not match.";
            $step = 2;
        }
    }
}
?>
<!doctype html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Forgot Password</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background: linear-gradient(135deg, #007bff, #00c6ff);
      margin: 0;
      padding: 0;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
    }
    .container {
      width: 100%;
      max-width: 420px;
      background: #fff;
      padding: 35px;
      border-radius: 14px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }
    h1 {
      text-align: center;
      color: #333;
      margin-bottom: 25px;
    }
    .msg {
      margin-bottom: 15px;
      padding: 12px;
      border-radius: 6px;
      font-size: 14px;
    }
    .msg a {
      color: #007bff;
      text-decoration: none;
    }
    .msg a:hover {
      text-decoration: underline;
    }
    .msg.success {
      background: #e6ffed;
      color: #256029;
      border: 1px solid #b3e6c3;
    }
    .msg.error {
      background: #ffe6e6;
      color: #a60000;
      border: 1px solid #ffb3b3;
    }
    form {
      display: flex;
      flex-direction: column;
    }
    label {
      margin-bottom: 6px;
      font-weight: bold;
      color: #444;
    }
    input[type="email"],
    input[type="password"] {
      padding: 12px;
      margin-bottom: 15px;
      border-radius: 8px;
      border: 1px solid #ccc;
      font-size: 15px;
      transition: border 0.3s, box-shadow 0.3s;
    }
    input:focus {
      border-color: #007bff;
      box-shadow: 0 0 4px rgba(0,123,255,0.6);
      outline: none;
    }
    button {
      padding: 12px;
      border: none;
      border-radius: 8px;
      background: #007bff;
      color: #fff;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      transition: background 0.3s;
    }
    button:hover {
      background: #0056b3;
    }
    .password-wrapper {
        position: relative;
        margin-bottom: 16px;
    }
    .password-wrapper input {
        width: 100%;
        padding: 12px 40px 12px 12px;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 15px;
        box-sizing: border-box;
    }
    .password-wrapper img {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        width: 22px;
        height: 22px;
        cursor: pointer;
        opacity: 0.6;
        transition: opacity 0.2s;
    }
    .password-wrapper img:hover {
        opacity: 1;
    }
    @media (min-width:481px) {   
        .container {
      width: 100%;
      max-width: 420px;
      background: #fff;
      padding: 35px;
      border-radius: 14px;
      box-shadow: 0 6px 20px rgba(0,0,0,0.2);
    }
   }
  </style>
</head>
<body>
  <div class="container">
    <h1>Forgot Password</h1>

    <?php if ($msg): ?>
      <div class="msg <?= strpos($msg, '✅') !== false ? 'success' : 'error' ?>">
        <?= $msg ?>
      </div>
    <?php endif; ?>

    <?php if ($step === 1): ?>
      <form method="post">
        <label>Email</label>
        <input type="email" name="email" placeholder="Enter your email" required>
        <button type="submit">Next</button>
      </form>
    <?php elseif ($step === 2): ?>
      <form method="post">
        <label>New Password</label>
        <div class="password-wrapper">
            <input type="password" name="new_password" id="password" placeholder="Enter new password" required>
            <img src="images/invisible.png" id="togglePassword">
        </div>
        <label>Confirm Password</label>
        <input type="password" name="confirm_password" id="confirm_password" placeholder="Confirm new password" required>
        <button type="submit">Reset Password</button>
      </form>
    <?php endif; ?>
  </div>
<script>
const togglePassword = document.getElementById('togglePassword');
const password = document.getElementById('password');
const confirmPassword = document.getElementById('confirm_password');

togglePassword.addEventListener('click', () => {
    if (password.type === 'password') {
        password.type = 'text';
        togglePassword.src = 'images/view.png';
    } else {
        password.type = 'password';
        togglePassword.src = 'images/invisible.png';
    }
});

// ✅ Client-side validation for confirm password
document.querySelector("form").addEventListener("submit", function(e) {
    if (password.value !== confirmPassword.value) {
        e.preventDefault();
        alert("Passwords do not match!");
        confirmPassword.focus();
    }
});
</script>
</body>
</html>
