<?php
session_start();
include 'config.php';

if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit;
}

$id = intval($_GET['id']);
$module = $conn->query("SELECT * FROM exams WHERE id=$id")->fetch_assoc();

// Update logic
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $title = $_POST['title'];
    $duration = $_POST['duration_minutes'];
    $is_active = isset($_POST['is_active']) ? 1 : 0;

    $stmt = $conn->prepare("UPDATE exams SET title=?, duration_minutes=?, is_active=? WHERE id=?");
    $stmt->bind_param("siii", $title, $duration, $is_active, $id);
    $stmt->execute();
    $stmt->close();

    header("Location: module.php"); 
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Edit Module</title>
    <style>
        body {
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background: #eef1f6;
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .content {
            background: #fff;
            padding: 25px 30px;
            border-radius: 12px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            margin-top: 60px;
            width: 420px;
        }

        h2 {
            text-align: center;
            color: #2d3748;
            margin-bottom: 20px;
        }

        form {
            display: flex;
            flex-direction: column;
            gap: 16px;
        }

        label {
            font-weight: 500;
            color: #555;
        }

        input[type="text"],
        input[type="number"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 14px;
            outline: none;
            transition: 0.3s;
        }

        input[type="text"]:focus,
        input[type="number"]:focus {
            border-color: #007bff;
            box-shadow: 0 0 4px rgba(0,123,255,0.3);
        }

        input[type="checkbox"] {
            transform: scale(1.2);
            margin-right: 6px;
        }

        button {
            padding: 12px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: #fff;
            font-size: 15px;
            font-weight: 500;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: all 0.3s;
        }

        button:hover {
            background: linear-gradient(135deg, #0056b3, #004494);
            transform: translateY(-2px);
            box-shadow: 0 4px 10px rgba(0,0,0,0.15);
        }
    </style>
</head>
<body>
    <div class="content">
        <h2>Edit Module</h2>
        <form method="post">
            <div>
                <label>Title:</label>
                <input type="text" name="title" value="<?= htmlspecialchars($module['title']) ?>" required>
            </div>

            <div>
                <label>Duration (minutes):</label>
                <input type="number" name="duration_minutes" value="<?= $module['duration_minutes'] ?>" required>
            </div>

            <div>
                <label>
                    <input type="checkbox" name="is_active" value="1" <?= $module['is_active'] ? 'checked' : '' ?>> Active
                </label>
            </div>

            <button type="submit">Update Module</button>
        </form>
    </div>
</body>
</html>
