<?php
// Start session only if not started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?php echo $page_title ?? 'Dashboard'; ?></title>

    <!-- TailwindCSS -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        body { 
            -webkit-user-select: none; 
            user-select: none; 
            -webkit-tap-highlight-color: transparent; 
            font-family: 'Inter', sans-serif; 
            overflow-x: hidden; 
        }
        .loading-modal { 
            position: fixed; top: 0; left: 0; 
            width: 100%; height: 100%; 
            background: rgba(0,0,0,0.5); 
            z-index: 9999; display: none; 
            align-items: center; justify-content: center; 
        }
        .loader { 
            width: 50px; height: 50px; 
            border: 5px solid #c02d2dff; 
            border-top: 5px solid #020e35ff; 
            border-radius: 50%; 
            animation: spin 1s linear infinite; 
        }
        #admin-menu-btn {
            background: white !important;
        }
        @keyframes spin { 
            0% { transform: rotate(0deg); } 
            100% { transform: rotate(360deg); } 
        }
    </style>
</head>
<body class="bg-gray-100">

<!-- Global Loading Modal -->
<div id="loading-modal" class="loading-modal"><div class="loader"></div></div>

<div class="flex min-h-screen">
    <?php include_once 'common/sidebar.php'; ?>

    <div class="flex-1 flex flex-col">
        <!-- Top Bar -->
        <header class="bg-white shadow-md px-6 py-3 flex justify-between items-center sticky top-0 z-30 h-16">
            <!-- Sidebar toggle (mobile only) -->
            <button id="admin-menu-btn" class="text-2xl text-gray-700 lg:hidden">
                <i class="fas fa-bars"></i>
            </button>

            <!-- Page Title -->
            <h1 class="text-lg md:text-xl font-semibold text-gray-800">
                <?php echo $page_title ?? 'Dashboard'; ?>
            </h1>

            <!-- Right Actions -->
            <div class="flex items-center space-x-4">
                <a href="logout.php" class="text-gray-600 hover:text-red-500" title="Logout">
                    <i class="fas fa-sign-out-alt text-lg"></i>
                </a>
            </div>
        </header>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const menuBtn = document.getElementById('admin-menu-btn');
    const closeBtn = document.getElementById('admin-close-btn');
    const sidebar = document.getElementById('admin-sidebar');
    const overlay = document.getElementById('admin-sidebar-overlay');

    if (menuBtn && closeBtn && sidebar && overlay) {
        // Open sidebar
        menuBtn.addEventListener('click', () => {
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
            document.body.classList.add('overflow-hidden'); // optional: disable scroll
        });

        // Close sidebar
        closeBtn.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
            document.body.classList.remove('overflow-hidden');
        });

        // Close sidebar by clicking overlay
        overlay.addEventListener('click', () => {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
            document.body.classList.remove('overflow-hidden');
        });
    }
});
</script>
</body>
</html>


    
