<?php
require_once __DIR__ . '/inc/bootstrap.php';
include 'common/header.php';
require_login('admin');
$flash=flash_get(); $cfg=read_config();
if(isset($_POST['save_duration'])){ $mins=max(1,intval($_POST['duration_minutes'] ?? 15)); $cfg['duration_minutes']=$mins; write_config($cfg); $flash='Saved duration: '.$mins.' minutes'; }
if(isset($_POST['save_admin'])){
    $name=trim($_POST['admin_name'] ?? ''); $email=trim($_POST['admin_email'] ?? ''); $password=$_POST['admin_password'] ?? '';
    $users=load_users(); $found=false;
    for($i=0;$i<count($users);$i++){ if(($users[$i]['role'] ?? '')==='admin'){ if($name) $users[$i]['name']=$name; if($email) $users[$i]['email']=$email; if($password) $users[$i]['password_hash']=password_hash($password, PASSWORD_BCRYPT); $found=true; break; } }
    if($found){ save_users($users); $flash='Admin details updated.'; }
}
?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin</title>
    <link rel="stylesheet" href="assets/style.css">
</head>

<body>
    
    </nav>
    <main class="container">
        <?php if(!empty($flash)): ?>
        <div class="flash">
            <div class="flash-item">
                <?=htmlspecialchars($flash)?>
            </div>
        </div>
        <?php endif; ?>
        <section class="card">
            <h2>Questions Upload</h2>
            <form method="post" action="upload_questions.php" enctype="multipart/form-data">
                <label>Select file (.xlsx or .csv)</label><input type="file" name="qfile" accept=".xlsx,.csv" required>
                <button class="primary" type="submit">Upload & Replace</button>
            </form>
            <p>Current file: <code>data/questions.xlsx</code> or <code>questions.csv</code>. Required columns: id,
                question, option_a, option_b, option_c, option_d. Optional: correct, image_path.</p>
        </section>
        <section class="card">
            <h2>Results</h2><a class="button" href="download_results.php">Download results.csv</a>
        </section>
        
        
    </main>
    <footer class="footer">
        <div class="container">&nbsp;</div>
    </footer>
</body>

</html>